
CREATE TABLE yazdCategory (
  categoryID     INT NOT NULL,
  name           VARCHAR(255),
  description    TEXT,
  modifiedDate   VARCHAR(15),
  creationDate   VARCHAR(15),
  catorder	 int,
  PRIMARY KEY    (categoryID)
);

CREATE TABLE yazdFilter (
  filterObject   BLOB,
  forumID        INT NOT NULL,
  filterIndex    INT NOT NULL,
  KEY            (forumID),
  KEY            (filterIndex)
);

CREATE TABLE yazdForum (
  forumID           INT NOT NULL,
  name              VARCHAR(255),
  description       TEXT,
  modifiedDate      VARCHAR(15),
  creationDate      VARCHAR(15),
  moderated         INT NOT NULL,
  forumGroupID      INT NOT NULL,
  article	    int not null,
  forumorder        int,
  PRIMARY KEY       (forumID)
);

CREATE TABLE yazdForumGroup (
  forumGroupID      INT NOT NULL,
  categoryID        INT NOT NULL,
  name              VARCHAR(255),
  description       TEXT,
  modifiedDate      VARCHAR(15),
  creationDate      VARCHAR(15),
  grporder	    int,
  PRIMARY KEY       (forumGroupID)
) ;

CREATE TABLE yazdForumProp (
  forumID     INT NOT NULL,
  name        VARCHAR(30) NOT NULL,
  propValue   VARCHAR(255) NOT NULL,
  KEY         (forumID,name)
);

CREATE TABLE yazdGroup (
  groupID      INT NOT NULL,
  name         VARCHAR(50) NOT NULL,
  description  VARCHAR(255),
  automember   int not null,
  PRIMARY KEY  (groupID)
);

CREATE TABLE yazdGroupPerm (
  forumID      INT NOT NULL,
  groupID      INT NOT NULL,
  permission   INT NOT NULL,
  KEY          (forumID),
  KEY          (groupID)
);

CREATE TABLE yazdGroupUser (
  groupID        INT NOT NULL,
  userID         INT NOT NULL,
  administrator  INT NOT NULL,
  PRIMARY KEY   (groupID,userID)
);

CREATE TABLE yazdMessage (
  messageID     INT NOT NULL,
  threadID      INT NOT NULL DEFAULT -1,
  subject       VARCHAR(255),
  userID        INT NOT NULL,
  body          TEXT,
  modifiedDate  VARCHAR(15) NOT NULL,
  creationDate  VARCHAR(15) NOT NULL,
  approved      INT NOT NULL,
  ranking       int null,
  replyPrivateUserId INT NOT NULL DEFAULT 0,
  PRIMARY KEY   (messageID),
  KEY           (userID),
  KEY           (threadID),
  KEY           (approved),
  KEY           (creationDate),
  KEY           (modifiedDate)
);

CREATE TABLE yazdMessageTree (
  parentID   INT NOT NULL,
  childID    INT NOT NULL,
  KEY        (parentID),
  KEY        (childID)
);

CREATE TABLE yazdMessageProp (
  messageID    INT NOT NULL,
  name         VARCHAR(30) NOT NULL,
  propValue    VARCHAR(255) NOT NULL,
  PRIMARY KEY  (messageID,name)
);

create table yazdThreadType(
  typeID   int not null,
  name     varchar(25) not null,
  PRIMARY KEY   (typeID)
);

insert into yazdThreadType values(0,'Other');
insert into yazdThreadType values(1,'Question');
insert into yazdThreadType values(2,'Comment');
insert into yazdThreadType values(3,'Announcement');


CREATE TABLE yazdThread (
  threadID      INT NOT NULL,
  forumID       INT NOT NULL,
  rootMessageID INT NOT NULL,
  approved      INT NOT NULL,
  readcnt       INT NOT NULL,
  typeID        int not null,
  sticky        int not null,
  closedflag    int not null,
  creationDate  VARCHAR(15) NOT NULL,
  modifiedDate  VARCHAR(15) NOT NULL,
  PRIMARY KEY   (threadID),
  KEY           (forumID),
  KEY           (rootMessageID),
  KEY           (creationDate),
  KEY           (modifiedDate)
);

CREATE TABLE yazdUser (
  userID        INT NOT NULL,
  name          VARCHAR(50),
  username      VARCHAR(30) NOT NULL,
  passwordHash  VARCHAR(32) NOT NULL,
  email         VARCHAR(75) NOT NULL,
  PRIMARY KEY   (userID)
);

CREATE TABLE yazdUserPerm (
  forumID      INT NOT NULL,
  userID       INT NOT NULL,
  permission   INT NOT NULL,
  KEY          (forumID),
  KEY          (userID)
);

CREATE TABLE yazdUserProp (
  userID     INT NOT NULL,
  name       VARCHAR(30) NOT NULL,
  propValue  VARCHAR(255) NOT NULL,
  KEY        (userID,name)
);


CREATE TABLE yazdProps (
       propvalue            VARCHAR(255),
       name                 VARCHAR(80) NOT NULL
);

CREATE UNIQUE INDEX XPKYAZD_props ON yazdProps
(
       name
);
CREATE TABLE yazdBlackList(
  ip		  varchar(30) not null,
  clientip	  varchar(30),
  blockcount	  int
);

CREATE TABLE yazdArticleMap(
  pageKey       varchar(255) not null,
  forumID       int not null,
  threadID      int not null
);
create table yazdSessions(
  sessionID   varchar(255) not null,
  IP          varchar(255) not null,
  userID      int null,
  lasttime    int not null,
  initime     int not null,
  primary key (sessionID)
);

create table yazdUserStats(
   day_dt int not null,
   usercount int not null, 
   maxusercount int not null, 
   maxuserdt varchar(15)
);

alter table yazdUserStats add primary key (day_dt);


ALTER TABLE yazdProps
       ADD PRIMARY KEY (name);

